﻿//////////////////////////////////////////////
// CompilationResultWrapper.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkScripts
{
	class Environment ;
}

/// Includes ---------------------------------

// nkAstraeus
#include "../../../Dll/DllDefines.h"

// nkScripts
#include <NilkinsScripts/Environments/Functions/Function.h>

/// Class ------------------------------------

namespace nkAstraeus::nkScriptsWrap
{
	class DLL_ASTRAEUS_EXPORT CompilationResultWrapper final
	{
		public :

			// Env
			static void updateEnvironment (nkScripts::Environment* env) ;

			// Callbacks
			// Constructor, destructor
			static void* constructor (const nkScripts::DataStack& stack) ;
			static void destructor (void* toDestroy) ;
			// Getters
			static nkScripts::OutputValue getFailureMessage (void* data) ;
			static nkScripts::OutputValue getFailureType (void* data) ;
			static nkScripts::OutputValue getSuccess (void* data) ;
			// Setters
			static void setFailureMessage (const nkScripts::DataStack& stack) ;
			static void setFailureType (const nkScripts::DataStack& stack) ;
			static void setSuccess (const nkScripts::DataStack& stack) ;
	} ;
}